<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Drink extends Model 
{

    protected $table = 'drinks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function items()
    {
        return $this->belongsToMany('App\Models\Item', 'item_drinks', 'drink_id', 'item_id');
    }

}